local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// Checkboxes
	self.CheckBoxes = {};
	
	// flags list
	local flags = "abcdefghijklmnopqrstuvwxyz+";
	
	// create checkboxes
	local i;
	for i = 1, string.len( flags ) do
		// fetch flag
		local flag = string.sub( flags, i, i );
	
		// create
		local checkbox = CtlCheckBox_class:create( self );
		checkbox:SetText( flag );
		checkbox.Flag = flag;
		
		// add
		table.insert( self.CheckBoxes, checkbox );
		
	end
	
end


// perform layout
function PANEL:PerformLayout( )
	//
	local width = self:GetWide();
	
	// figure out the spacing.
	local spacing = width / 6;
	
	//
	local offset = 0;
	
	// column counter
	local column = 0;
	
	//
	local i;
	for i = 1, table.getn( self.CheckBoxes ) do
		// position it.
		local box = self.CheckBoxes[ i ];
		
		// position
		box:SetPos(
			column * spacing,
			offset
		);
		
		// size
		box:SetSize(
			spacing,
			24
		);
		
		//
		column = column + 1;
		
		// max columns?
		if( column == 6 ) then
			// reset counter
			column = 0;
			
			// increase offset
			offset = offset + 24;
			
		end
	
	end
	
	//
	self:SetSize( width, offset + 24 );
	
end

// get flags
function PANEL:GetFlags( )
	//
	local flags = {};

	//
	local i;
	for i = 1, table.getn( self.CheckBoxes ) do
		// position it.
		local box = self.CheckBoxes[ i ];
		
		// checked?
		if( box:GetChecked() ) then
			table.insert( flags, box.Flag );
		
		end
			
	end
	
	//
	return table.concat( flags );

end

// set flags
function PANEL:SetFlags( flags )
	//
	local i;
	for i = 1, table.getn( self.CheckBoxes ) do
		// position it.
		local box = self.CheckBoxes[ i ];
		
		// check
		box:SetChecked( string.find( flags, box.Flag ) != nil );

	end

end

// draw
function PANEL:Paint( )
	//
	local width, height = self:GetSize();
	
	// frame.
	//AppFramework:Theme():DrawFrame( width - 96, 0, 96, height, FRAME_INSET, self.Color );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_accessflags_element", PANEL, "Panel" );




// create app framework control.
CtlAccessFlagsElement_class 	= Control_class:create( nil, false, "ctl_accessflags_element" );

//
function CtlAccessFlagsElement_class:GetFlags( )
	return self:GetHandle():GetFlags();

end

//
function CtlAccessFlagsElement_class:SetFlags( flags )
	return self:GetHandle():SetFlags( flags );

end

